(function(){
  function digitsOnly(v){ return (v || '').replace(/\D+/g,''); }

  function setupWrap(wrap){
    var area = wrap.querySelector('input[data-wf-phone="area"]');
    var pref = wrap.querySelector('input[data-wf-phone="prefix"]');
    var line = wrap.querySelector('input[data-wf-phone="line"]');
    var hidden = wrap.querySelector('input[data-wf-phone="hidden"]');
    if(!area || !pref || !line || !hidden) return;

    function clamp(el, max){
      var d = digitsOnly(el.value);
      if(d.length > max) d = d.slice(0, max);
      el.value = d;
      return d;
    }

    function sync(){
      var a = clamp(area, 3);
      var p = clamp(pref, 3);
      var l = clamp(line, 4);
      var combined = (a + p + l);
      hidden.value = combined;
    }

    function maybeAdvance(el, max, next){
      var d = clamp(el, max);
      if(d.length === max && next){
        next.focus();
        next.select && next.select();
      }
      sync();
    }

    area.addEventListener('input', function(){ maybeAdvance(area, 3, pref); });
    pref.addEventListener('input', function(){ maybeAdvance(pref, 3, line); });
    line.addEventListener('input', function(){ clamp(line, 4); sync(); });

    // Handle paste of full number into any part.
    function handlePaste(e){
      var text = (e.clipboardData || window.clipboardData).getData('text') || '';
      var d = digitsOnly(text);
      if(!d) return;
      // Drop leading country 1 if present and length 11
      if(d.length === 11 && d[0] === '1') d = d.slice(1);
      if(d.length < 10) return; // let normal paste happen
      e.preventDefault();
      area.value = d.slice(0,3);
      pref.value = d.slice(3,6);
      line.value = d.slice(6,10);
      sync();
      line.focus();
    }
    area.addEventListener('paste', handlePaste);
    pref.addEventListener('paste', handlePaste);
    line.addEventListener('paste', handlePaste);

    // On load, ensure hidden matches.
    sync();
  }

  function init(){
    var wraps = document.querySelectorAll('.warforms-reboot-form .wf-phone[data-wf-phone="wrap"]');
    for(var i=0;i<wraps.length;i++) setupWrap(wraps[i]);
  }

  if(document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
})();
